////////////////////////////////////////////////////////////////////////////////
/*!
  @file   shadow_gen_vert.glsl
  @author Tommy A. Brosman IV
  @par    email:  tbrosman\@digipen.edu
  @date   December 1, 2008
  @date   February 6, 2011

  @brief
    Vert shader for generating shadow maps.
*/
////////////////////////////////////////////////////////////////////////////////

#define SHADOW_NEAR_PLANE 0.1
#define SHADOW_FAR_PLANE 100.0

varying float depth;

void main()
{
  gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;
  depth       = (-(gl_ModelViewMatrix * gl_Vertex).z - SHADOW_NEAR_PLANE) / (SHADOW_FAR_PLANE - SHADOW_NEAR_PLANE);
}