////////////////////////////////////////////////////////////////////////////////
/*!
  @file   shadow_gen_frag.glsl
  @author Tommy A. Brosman IV
  @par    email:  tbrosman\@digipen.edu
  @date   December 1, 2008
  @date   February 6, 2011

  @brief
    Fragment shader for generating shadow maps.
*/
////////////////////////////////////////////////////////////////////////////////

#define DEPTH_EPS 0.005

varying float depth;

vec4 FloatToSample(in float f)
{
  vec4 sample;
  f *= 256.0;
  sample.r = floor(f) / 256.0;
  f = 256.0 * fract(f);
  sample.g = floor(f) / 256.0;
  f = 256.0 * fract(f);
  sample.b = floor(f) / 256.0;
  f = 256.0 * fract(f);
  sample.a = floor(f) / 256.0;
  return sample;
}

void main(void)
{
  //gl_FragData[0].rgb = vec3(1.0, 1.0, 0.0);
  //gl_FragData[0].a = 1.0;
  gl_FragData[0] = FloatToSample(min(0.99999999, depth + DEPTH_EPS));
}
