varying vec3 normal;
varying vec3 lightVec;
varying float depth;
const vec4 worldLightVec = vec4(6, 9, 2, 1);

// For shadows
uniform mat4 lightToTex;
uniform mat4 viewToLight;
varying vec4 lightVert;
varying vec4 shadowTexCoord;


uniform mat4 viewToWorld;
uniform mat4 worldToLight;
uniform mat4 lightProj;

const mat4 lightProjToTex =
  mat4(0.5, 0.0, 0.0, 0.0,
       0.0, 0.5, 0.0, 0.0,
       0.0, 0.0, 0.5, 0.0,
       0.5, 0.5, 0.5, 1.0);


#define NEAR_PLANE 0.1
#define FAR_PLANE 300.0

void main()
{
  lightVec       = (gl_ModelViewProjectionMatrix * worldLightVec).xyz;
  gl_Position    = gl_ModelViewProjectionMatrix * gl_Vertex;
  //gl_Position    = lightProj * worldToLight * viewToWorld * gl_ModelViewMatrix * gl_Vertex;
  normal         = (gl_NormalMatrix * gl_Normal).xyz;
  gl_FrontColor  = gl_Color;
  gl_TexCoord[0] = gl_TextureMatrix[0] * gl_MultiTexCoord0;
  depth          = (-(gl_ModelViewMatrix * gl_Vertex).z - NEAR_PLANE) / (FAR_PLANE - NEAR_PLANE);
  
  /*
  // model -> camView -> world -> lightView
  lightVert = (worldToLight * viewToWorld * gl_ModelViewMatrix * gl_Vertex);

  // lightView -> lightNDC -> textureCoord
  shadowTexCoord = (lightProjToTex * lightProj * lightVert);
  */
}