#pragma optimize(on)
#pragma optionNV(fastmath on)
#pragma optionNV(fastprecision on)
#pragma optionNV(ifcvt none)
#pragma optionNV(inline all)
#pragma optionNV(strict on)
#pragma optionNV(unroll all)

#define NEAR_PLANE 0.1
#define FAR_PLANE 300.0

#define SHADOW_TEX_WIDTH  800.0
#define SHADOW_TEX_HEIGHT 600.0
#define SHADOW_NEAR_PLANE 0.1
#define SHADOW_FAR_PLANE 100.0
#define CONV_RADIUS 1

// For shadows
uniform sampler2D shadowTex;
uniform sampler2D normalNoiseTex;
varying vec4 lightVert;
varying vec4 shadowTexCoord;
const float scaleFactor = 2.2;

// For render targets
varying vec3 normal;
varying float depth;

vec4 FloatToSample(in float f)
{
  vec4 sample;
  f *= 256.0;
  sample.r = floor(f) / 256.0;
  f = 256.0 * fract(f);
  sample.g = floor(f) / 256.0;
  f = 256.0 * fract(f);
  sample.b = floor(f) / 256.0;
  f = 256.0 * fract(f);
  sample.a = floor(f) / 256.0;
  return sample;
}

float SampleToFloat(in vec4 sample)
{
  return sample.r + (sample.g / 256.0) + (sample.b / 65536.0) + (sample.a / 16777216.0);
}

float NormDepthToWorld(in float d)
{
  return (d * (SHADOW_FAR_PLANE - SHADOW_NEAR_PLANE)) + SHADOW_NEAR_PLANE;
}

float CalculateShadowBias()
{
  // project
  vec4 shadowCoord = shadowTexCoord / shadowTexCoord.w;
  
  // Avoid z-fighting
  //shadowCoord.z += 0.0001;

  // map the fragment back into the range [near, far]
  float D = NormDepthToWorld(SampleToFloat(texture2D(shadowTex, shadowCoord.xy)));
  
  // Build random rotation
  float angle = texture2D(normalNoiseTex, (0.5*normal.xy + vec2(0.5)) * (1.0/600.0) * gl_FragCoord.xy ).r;
  mat2 rotMat = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));
  //mat2 rotMat = mat2(1.0, 0.0, 0.0, 1.0);

  if(-lightVert.z > (D - 20.0))
  {
    float shadowPercent;
    
    float factor = 1.0/((2.0*float(CONV_RADIUS) + 1.0) * (2.0*float(CONV_RADIUS) + 1.0));
    
    // in shadow
    for(int s = -CONV_RADIUS; s <= CONV_RADIUS; s++)
    {
      for(int t = -CONV_RADIUS; t <= CONV_RADIUS; t++)
      {
        vec2 sample = rotMat * vec2(s / SHADOW_TEX_WIDTH, t / SHADOW_TEX_HEIGHT);
        vec4 shadowSample = texture2D(shadowTex, shadowCoord.st + scaleFactor * sample);
        float Dst = NormDepthToWorld(SampleToFloat(shadowSample));
        shadowPercent += factor * step(0.0, -lightVert.z - Dst);
      }
    }

    return shadowPercent;
  }
  else
  {
    return 0.0;
  }
}

void main(void)
{
  gl_FragData[0] = FloatToSample(min(0.99999, depth));

  //vec2 shadowCoord = (1.0 / shadowTexCoord.w) * shadowTexCoord.xy;
  //gl_FragData[1].rgb = vec3(SampleToFloat(texture2D(shadowTex, vec2(gl_FragCoord.x / 600.0, gl_FragCoord.y / 800.0))));
  //gl_FragData[1].rgb = (1.0 - CalculateShadowBias()) * gl_Color.rgb;
  gl_FragData[1].rgb = gl_Color.rgb;
  gl_FragData[1].a = 1.0;

	gl_FragData[2].rgb = 0.5*(normal + vec3(1.0));
  gl_FragData[2].a = 1.0;
  
  //gl_FragData[3] = FloatToSample(1.0 - CalculateShadowBias());
}
