#pragma optimize(on)
#pragma optionNV(fastmath on)
#pragma optionNV(fastprecision on)
#pragma optionNV(ifcvt none)
#pragma optionNV(inline all)
#pragma optionNV(strict on)
#pragma optionNV(unroll all)

//#define SCREEN_WIDTH 1200.0
//#define SCREEN_HEIGHT 900.0

uniform vec4 cameraLightVec;
uniform sampler2D geomTex;
uniform sampler2D depthTex;
uniform sampler2D normalTex;

vec2 TexelToScreen(in vec2 texCoord)
{
  return vec2((SCREEN_WIDTH / 2.0) * texCoord.x, (SCREEN_HEIGHT / 2.0) * texCoord.y);
}

vec2 ScreenToTexel(in vec2 texCoord)
{
  return vec2((2.0 / SCREEN_WIDTH) * texCoord.x, (2.0 / SCREEN_HEIGHT) * texCoord.y);
}

float SampleToFloat(in vec4 sample)
{
  return sample.r + (sample.g / 256.0) + (sample.b / 65536.0) + (sample.a / 16777216.0);
}

void main(void)
{
  vec2 uv = gl_TexCoord[0].st;
  //vec3 normal = 
  float depth = SampleToFloat(texture2D(depthTex, uv));
  vec4 color = texture2D(geomTex, uv);
  
  float Gx, Gy;
  Gx = -1 * SampleToFloat(texture2D(depthTex, uv + ScreenToTexel(vec2(-1, -1))));
       -2 * SampleToFloat(texture2D(depthTex, uv + ScreenToTexel(vec2(-1, 0))));
       -1 * SampleToFloat(texture2D(depthTex, uv + ScreenToTexel(vec2(-1, +1))));
       +1 * SampleToFloat(texture2D(depthTex, uv + ScreenToTexel(vec2(+1, -1))));
       +2 * SampleToFloat(texture2D(depthTex, uv + ScreenToTexel(vec2(+1, 0))));
       +1 * SampleToFloat(texture2D(depthTex, uv + ScreenToTexel(vec2(+1, +1))));
  
  Gy = -1 * SampleToFloat(texture2D(depthTex, uv + ScreenToTexel(vec2(-1, -1))));
       -2 * SampleToFloat(texture2D(depthTex, uv + ScreenToTexel(vec2(0, -1))));
       -1 * SampleToFloat(texture2D(depthTex, uv + ScreenToTexel(vec2(+1, -1))));
       +1 * SampleToFloat(texture2D(depthTex, uv + ScreenToTexel(vec2(-1, +1))));
       +2 * SampleToFloat(texture2D(depthTex, uv + ScreenToTexel(vec2(0, +1))));
       +1 * SampleToFloat(texture2D(depthTex, uv + ScreenToTexel(vec2(+1, +1))));
       
  float dx = SampleToFloat(texture2D(depthTex, uv + ScreenToTexel(vec2(+1, 0))))
           - SampleToFloat(texture2D(depthTex, uv + ScreenToTexel(vec2(-1, 0))));
           
  float dy = SampleToFloat(texture2D(depthTex, uv + ScreenToTexel(vec2(0, +1))))
           - SampleToFloat(texture2D(depthTex, uv + ScreenToTexel(vec2(0, -1))));
           
  float derivStep = 0.001;
  vec3 partialX = vec3(derivStep, dx, 0.0);
  vec3 partialY = vec3(0.0, dy, derivStep);
  
  //vec3 norm = normalize(cross(partialX, partialY));
  vec3 norm = 2.0 * texture2D(normalTex, uv).rgb - vec3(1.0);
  
  //vec3 norm = normalize(vec3(Gx, -1.0f, Gy));
  float shadeValue = smoothstep(0.6, 1.0, dot(norm, -normalize(cameraLightVec.xyz)));
  //float shadeValue = dot(norm, -normalize(lightVec));

  float coeff = 600000.0;
  float nL = smoothstep(0.0, 1.0, dot(normalize(norm), normalize(cameraLightVec.xyz)));
  
  /*
  vec3 halfVec = normalize(normalize(cameraLightVec.xyz) + vec3(0.0, 0.0, 1.0));
  float specular = smoothstep(0.0, 1.0, pow(dot(halfVec, norm), 5));
  */
  
  //gl_FragColor.rgb = vec3(coeff * length(cross(partialX, partialY)) * color.rgb);
  gl_FragColor.rgb = (0.4 + 0.6*nL) * color.rgb;

  gl_FragColor.a = 1.0;
}
